<?php
header('Content-Type: application/json');
require_once 'config.php';

// Test location data for phone 01729544553
$testData = [
    [
        'phone_name' => '01729544553',
        'latitude' => 23.8103,
        'longitude' => 90.4125,
        'timestamp' => time() * 1000 - 3600000 // 1 hour ago
    ],
    [
        'phone_name' => '01729544553',
        'latitude' => 23.8150,
        'longitude' => 90.4200,
        'timestamp' => time() * 1000 - 1800000 // 30 minutes ago
    ],
    [
        'phone_name' => '01729544553',
        'latitude' => 23.8200,
        'longitude' => 90.4250,
        'timestamp' => time() * 1000 // now
    ]
];

$conn = getDBConnection();
$results = [];

foreach ($testData as $data) {
    $phoneName = sanitizeTableName($data['phone_name']);
    $tableName = $phoneName . '_location';
    
    // Create table if not exists
    createTableIfNotExists($conn, $phoneName, 'location');
    
    // Insert location data
    $stmt = $conn->prepare("INSERT INTO `{$tableName}` (phone_name, latitude, longitude, timestamp) VALUES (?, ?, ?, ?)");
    
    if ($stmt) {
        $stmt->bind_param("sddi", 
            $data['phone_name'],
            $data['latitude'],
            $data['longitude'],
            $data['timestamp']
        );
        
        if ($stmt->execute()) {
            $results[] = [
                'success' => true,
                'phone_name' => $data['phone_name'],
                'latitude' => $data['latitude'],
                'longitude' => $data['longitude'],
                'timestamp' => $data['timestamp']
            ];
        } else {
            $results[] = [
                'success' => false,
                'error' => 'Failed to insert: ' . $stmt->error,
                'data' => $data
            ];
        }
        
        $stmt->close();
    } else {
        $results[] = [
            'success' => false,
            'error' => 'Failed to prepare statement',
            'data' => $data
        ];
    }
}

$conn->close();

echo json_encode([
    'success' => true,
    'message' => 'Test location data insertion completed',
    'results' => $results
]);
?>

