/*
 * Decompiled with CFR 0.152.
 */
package com.example.sms_call_sync;

import android.content.Context;
import android.os.Bundle;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.example.sms_call_sync.R;
import com.example.sms_call_sync.SyncManager;
import java.util.ArrayList;
import java.util.Set;

public class SettingsActivity
extends AppCompatActivity {
    private EditText etBlockedNumber;
    private Button btnAddBlockedNumber;
    private ListView lvBlockedNumbers;
    private ArrayAdapter<String> blockedNumbersAdapter;
    private ArrayList<String> blockedNumbersList;
    private SyncManager syncManager;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_settings);
        this.initViews();
        this.syncManager = new SyncManager((Context)this);
        this.loadBlockedNumbers();
        this.setupListeners();
    }

    private void initViews() {
        this.etBlockedNumber = (EditText)this.findViewById(R.id.et_blocked_number);
        this.btnAddBlockedNumber = (Button)this.findViewById(R.id.btn_add_blocked_number);
        this.lvBlockedNumbers = (ListView)this.findViewById(R.id.lv_blocked_numbers);
    }

    private void loadBlockedNumbers() {
        Set<String> blockedSet = this.syncManager.getDbHelper().getBlockedNumbers();
        this.blockedNumbersList = new ArrayList<String>(blockedSet);
        this.blockedNumbersAdapter = new ArrayAdapter((Context)this, 17367043, this.blockedNumbersList);
        this.lvBlockedNumbers.setAdapter(this.blockedNumbersAdapter);
    }

    private void setupListeners() {
        this.btnAddBlockedNumber.setOnClickListener(v -> this.addBlockedNumber());
        this.lvBlockedNumbers.setOnItemClickListener((parent, view, position, id2) -> {
            String numberToRemove = this.blockedNumbersList.get(position);
            this.syncManager.removeBlockedNumber(numberToRemove);
            this.blockedNumbersList.remove(position);
            this.blockedNumbersAdapter.notifyDataSetChanged();
            Toast.makeText((Context)this, (CharSequence)("Removed: " + numberToRemove), (int)0).show();
        });
    }

    private void addBlockedNumber() {
        String number = this.etBlockedNumber.getText().toString().trim();
        if (number.isEmpty()) {
            Toast.makeText((Context)this, (CharSequence)"Please enter a number to block", (int)0).show();
            return;
        }
        if (this.blockedNumbersList.contains(number)) {
            Toast.makeText((Context)this, (CharSequence)"Number already blocked", (int)0).show();
            return;
        }
        this.syncManager.addBlockedNumber(number);
        this.blockedNumbersList.add(number);
        this.blockedNumbersAdapter.notifyDataSetChanged();
        this.etBlockedNumber.setText((CharSequence)"");
        Toast.makeText((Context)this, (CharSequence)("Number blocked: " + number), (int)0).show();
    }
}

