/*
 * Decompiled with CFR 0.152.
 */
package com.example.sms_call_sync;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.example.sms_call_sync.R;
import com.example.sms_call_sync.SettingsActivity;
import com.example.sms_call_sync.SyncManager;
import java.util.ArrayList;

public class MainActivity
extends AppCompatActivity {
    private static final int PERMISSION_REQUEST_CODE = 100;
    private EditText etServerUrl;
    private EditText etPhoneName;
    private Button btnSyncSms;
    private Button btnSyncCalls;
    private Button btnAutoSync;
    private Button btnSettings;
    private SyncManager syncManager;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_main);
        this.initViews();
        this.syncManager = new SyncManager((Context)this);
        this.loadSavedPreferences();
        this.setupListeners();
        this.checkAndRequestPermissions();
    }

    private void initViews() {
        this.etServerUrl = (EditText)this.findViewById(R.id.et_server_url);
        this.etPhoneName = (EditText)this.findViewById(R.id.et_phone_name);
        this.btnSyncSms = (Button)this.findViewById(R.id.btn_sync_sms);
        this.btnSyncCalls = (Button)this.findViewById(R.id.btn_sync_calls);
        this.btnAutoSync = (Button)this.findViewById(R.id.btn_auto_sync);
        this.btnSettings = (Button)this.findViewById(R.id.btn_settings);
    }

    private void loadSavedPreferences() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
        String savedServerUrl = sharedPreferences.getString("server_url", "");
        String savedPhoneName = sharedPreferences.getString("phone_name", "");
        this.etServerUrl.setText((CharSequence)savedServerUrl);
        this.etPhoneName.setText((CharSequence)savedPhoneName);
    }

    private void savePreferences() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("server_url", this.etServerUrl.getText().toString());
        editor.putString("phone_name", this.etPhoneName.getText().toString());
        editor.apply();
    }

    private void setupListeners() {
        this.btnSyncSms.setOnClickListener(v -> this.syncSms());
        this.btnSyncCalls.setOnClickListener(v -> this.syncCallHistory());
        this.btnAutoSync.setOnClickListener(v -> this.toggleAutoSync());
        this.btnSettings.setOnClickListener(v -> this.openSettings());
    }

    private void syncSms() {
        this.savePreferences();
        String serverUrl = this.etServerUrl.getText().toString();
        String phoneName = this.etPhoneName.getText().toString();
        if (serverUrl.isEmpty() || phoneName.isEmpty()) {
            Toast.makeText((Context)this, (CharSequence)"Please enter Server URL and Phone Name", (int)0).show();
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_SMS") != 0) {
            Toast.makeText((Context)this, (CharSequence)"READ_SMS permission is required to sync SMS.", (int)1).show();
            this.checkAndRequestPermissions();
            return;
        }
        Toast.makeText((Context)this, (CharSequence)"Syncing SMS...", (int)0).show();
        this.syncManager.syncSms(serverUrl, phoneName);
    }

    private void syncCallHistory() {
        this.savePreferences();
        String serverUrl = this.etServerUrl.getText().toString();
        String phoneName = this.etPhoneName.getText().toString();
        if (serverUrl.isEmpty() || phoneName.isEmpty()) {
            Toast.makeText((Context)this, (CharSequence)"Please enter Server URL and Phone Name", (int)0).show();
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_CALL_LOG") != 0) {
            Toast.makeText((Context)this, (CharSequence)"READ_CALL_LOG permission is required to sync Call History.", (int)1).show();
            this.checkAndRequestPermissions();
            return;
        }
        Toast.makeText((Context)this, (CharSequence)"Syncing Call History...", (int)0).show();
        this.syncManager.syncCallHistory(serverUrl, phoneName);
    }

    private void toggleAutoSync() {
        Toast.makeText((Context)this, (CharSequence)"Auto Sync Toggled (Not yet implemented)", (int)0).show();
    }

    private void openSettings() {
        Intent intent = new Intent((Context)this, SettingsActivity.class);
        this.startActivity(intent);
    }

    private void checkAndRequestPermissions() {
        String[] permissions = new String[]{"android.permission.READ_SMS", "android.permission.RECEIVE_SMS", "android.permission.READ_CALL_LOG", "android.permission.INTERNET", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
        ArrayList<String> permissionsToRequest = new ArrayList<String>();
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0) continue;
            permissionsToRequest.add(permission2);
        }
        if (!permissionsToRequest.isEmpty()) {
            ActivityCompat.requestPermissions((Activity)this, (String[])permissionsToRequest.toArray(new String[0]), (int)100);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 100) {
            boolean allPermissionsGranted = true;
            for (int result : grantResults) {
                if (result == 0) continue;
                allPermissionsGranted = false;
                break;
            }
            if (allPermissionsGranted) {
                Toast.makeText((Context)this, (CharSequence)"All required permissions granted!", (int)0).show();
            } else {
                Toast.makeText((Context)this, (CharSequence)"Some permissions were denied. App functionality may be limited.", (int)1).show();
            }
        }
    }
}

